/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.structures.DungeonDoor;
import wayoftime.bloodmagic.structures.DungeonStructure;
import wayoftime.bloodmagic.structures.DungeonUtil;

public class DungeonRoom {
    public ResourceLocation key;
    public int dungeonWeight = 1;
    public Map<String, BlockPos> structureMap = new TreeMap<String, BlockPos>();
    public Map<String, Map<Direction, List<BlockPos>>> doorMap = new TreeMap<String, Map<Direction, List<BlockPos>>>();
    public List<AreaDescriptor.Rectangle> descriptorList = new ArrayList<AreaDescriptor.Rectangle>();
    public float oreDensity = 0.0f;
    public BlockPos spawnLocation = BlockPos.f_121853_;
    public BlockPos controllerOffset = BlockPos.f_121853_;
    public BlockPos portalOffset = BlockPos.f_121853_;
    public Map<Integer, List<BlockPos>> indexToDoorMap = new TreeMap<Integer, List<BlockPos>>();
    public Map<Integer, List<String>> indexToRoomTypeMap = new TreeMap<Integer, List<String>>();
    public Map<String, List<BlockPos>> requiredDoorMap = new TreeMap<String, List<BlockPos>>();
    public Map<Integer, AreaDescriptor.Rectangle> doorCoverMap = new TreeMap<Integer, AreaDescriptor.Rectangle>();

    public DungeonRoom(Map<String, BlockPos> structureMap, Map<String, Map<Direction, List<BlockPos>>> doorMap, List<AreaDescriptor.Rectangle> descriptorList) {
        this.structureMap = structureMap;
        this.doorMap = doorMap;
        this.descriptorList = descriptorList;
    }

    public DungeonRoom() {
        this(new TreeMap<String, BlockPos>(), new TreeMap<String, Map<Direction, List<BlockPos>>>(), new ArrayList<AreaDescriptor.Rectangle>());
    }

    public DungeonRoom addStructure(String location, BlockPos pos) {
        this.structureMap.put(location, pos);
        return this;
    }

    public DungeonRoom addAreaDescriptor(AreaDescriptor.Rectangle descriptor) {
        descriptor.setDoCache(false);
        this.descriptorList.add(descriptor);
        return this;
    }

    public DungeonRoom addNonstandardDoor(BlockPos pos, Direction dir, String thisDoorType, int index, String wantedDoorType) {
        if (!this.requiredDoorMap.containsKey(wantedDoorType)) {
            this.requiredDoorMap.put(wantedDoorType, new ArrayList());
        }
        this.requiredDoorMap.get(wantedDoorType).add(pos);
        return this.addDoor(pos, dir, thisDoorType, index);
    }

    public DungeonRoom addDoor(BlockPos pos, Direction dir, String doorType, int index) {
        Map<Direction, List<BlockPos>> dirMap;
        if (!this.doorMap.containsKey(doorType)) {
            this.doorMap.put(doorType, new TreeMap());
        }
        if (!(dirMap = this.doorMap.get(doorType)).containsKey(dir)) {
            dirMap.put(dir, new ArrayList());
        }
        dirMap.get(dir).add(pos);
        if (!this.indexToDoorMap.containsKey(index)) {
            this.indexToDoorMap.put(index, new ArrayList());
        }
        this.indexToDoorMap.get(index).add(pos);
        return this;
    }

    public DungeonRoom addDoors(Direction dir, String doorType, int index, BlockPos ... positions) {
        if (positions.length <= 0) {
            return this;
        }
        for (int i = 0; i < positions.length; ++i) {
            this.addDoor(positions[i], dir, doorType, index);
        }
        return this;
    }

    public DungeonRoom addNormalRoomPool(int index, ResourceLocation roomPool) {
        return this.addRoomPool(index, roomPool.toString());
    }

    public DungeonRoom addSpecialRoomPool(int index, ResourceLocation roomPool) {
        return this.addRoomPool(index, "#" + roomPool.toString());
    }

    public DungeonRoom addDeadendRoomPool(int index, ResourceLocation roomPool) {
        return this.addRoomPool(index, "$" + roomPool.toString());
    }

    public DungeonRoom addRoomPool(int index, String roomPool) {
        if (!this.indexToRoomTypeMap.containsKey(index)) {
            this.indexToRoomTypeMap.put(index, new ArrayList());
        }
        this.indexToRoomTypeMap.get(index).add(roomPool);
        return this;
    }

    public DungeonRoom setOreDensity(float oreDensity) {
        this.oreDensity = oreDensity;
        return this;
    }

    public BlockPos getOriginalBlockPos(BlockPos worldDoorPos, StructurePlaceSettings settings, BlockPos offset) {
        StructurePlaceSettings oppositeSettings = settings.m_74374_();
        switch (settings.m_74404_()) {
            case CLOCKWISE_90: {
                oppositeSettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                oppositeSettings.m_74379_(Rotation.CLOCKWISE_90);
                break;
            }
        }
        return StructureTemplate.m_74563_((StructurePlaceSettings)oppositeSettings, (BlockPos)worldDoorPos).m_141950_((Vec3i)offset);
    }

    public int getIndexForDoor(BlockPos originalDoorPos) {
        for (Map.Entry<Integer, List<BlockPos>> entry : this.indexToDoorMap.entrySet()) {
            if (!entry.getValue().contains(originalDoorPos)) continue;
            return entry.getKey();
        }
        return 1;
    }

    public DungeonRoom registerDoorFill(int index, AreaDescriptor.Rectangle desc) {
        this.doorCoverMap.put(index, desc);
        return this;
    }

    public AreaDescriptor getDoorFillDescriptor(BlockPos originalDoorPos) {
        int index = this.getIndexForDoor(originalDoorPos);
        if (this.doorCoverMap.containsKey(index)) {
            return this.doorCoverMap.get(index);
        }
        return new AreaDescriptor.Rectangle(new BlockPos(-1, -1, 0), 3, 3, 1);
    }

    public AreaDescriptor getDoorFillDescriptor(StructurePlaceSettings settings, BlockPos originalDoorPos, BlockPos newDoorPos, Direction dir) {
        StructurePlaceSettings rotatedSettings = settings.m_74374_();
        rotatedSettings.m_74379_(rotatedSettings.m_74404_().m_55952_(this.getRotationForDirectionFromNorth(dir)));
        AreaDescriptor desc = this.getDoorFillDescriptor(originalDoorPos);
        return desc.rotateDescriptor(rotatedSettings);
    }

    public Rotation getRotationForDirectionFromNorth(Direction dir) {
        switch (dir) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public List<DungeonDoor> getPotentialConnectedRoomTypes(StructurePlaceSettings settings, BlockPos offset) {
        ArrayList<DungeonDoor> dungeonDoorList = new ArrayList<DungeonDoor>();
        for (Map.Entry<String, Map<Direction, List<BlockPos>>> entry : this.doorMap.entrySet()) {
            Map<Direction, List<BlockPos>> doorDirMap = entry.getValue();
            String doorType = entry.getKey();
            for (int i = 0; i < 4; ++i) {
                Direction originalFacing = Direction.m_122407_((int)i);
                if (!doorDirMap.containsKey(originalFacing)) continue;
                Direction rotatedFacing = DungeonUtil.getFacingForSettings(settings, originalFacing);
                List<BlockPos> doorList = doorDirMap.get(originalFacing);
                if (this.indexToDoorMap == null || this.indexToDoorMap.isEmpty()) {
                    ArrayList<String> roomTypeList = new ArrayList<String>();
                    for (BlockPos doorPos : doorList) {
                        BlockPos newDoorPos = StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)doorPos).m_141952_((Vec3i)offset);
                        dungeonDoorList.add(new DungeonDoor(newDoorPos, rotatedFacing, doorType, roomTypeList, this.getDoorFillDescriptor(settings, doorPos, newDoorPos, originalFacing)));
                    }
                    continue;
                }
                for (Map.Entry<Integer, List<BlockPos>> rotatedIndexEntry : this.indexToDoorMap.entrySet()) {
                    int index = rotatedIndexEntry.getKey();
                    List<String> roomTypeList = this.indexToRoomTypeMap.get(index);
                    List<BlockPos> indexedDoorList = rotatedIndexEntry.getValue();
                    for (BlockPos indexPos : indexedDoorList) {
                        if (!doorList.contains(indexPos)) continue;
                        String requiredType = this.getRequiredDoorType(doorType, indexPos);
                        BlockPos newDoorPos = StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)indexPos).m_141952_((Vec3i)offset);
                        dungeonDoorList.add(new DungeonDoor(newDoorPos, rotatedFacing, requiredType, roomTypeList, this.getDoorFillDescriptor(settings, indexPos, newDoorPos, originalFacing)));
                    }
                }
            }
        }
        return dungeonDoorList;
    }

    public String getRequiredDoorType(String type, BlockPos indexPos) {
        for (Map.Entry<String, List<BlockPos>> entry : this.requiredDoorMap.entrySet()) {
            if (!entry.getValue().contains(indexPos)) continue;
            return entry.getKey();
        }
        return type;
    }

    public List<AreaDescriptor> getAreaDescriptors(StructurePlaceSettings settings, BlockPos offset) {
        ArrayList<AreaDescriptor> newList = new ArrayList<AreaDescriptor>();
        for (AreaDescriptor areaDescriptor : this.descriptorList) {
            newList.add(areaDescriptor.rotateDescriptor(settings).offset(offset));
        }
        return newList;
    }

    public BlockPos getPlayerSpawnLocationForPlacement(StructurePlaceSettings settings, BlockPos offset) {
        return StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)this.spawnLocation).m_141952_((Vec3i)offset);
    }

    public BlockPos getPortalOffsetLocationForPlacement(StructurePlaceSettings settings, BlockPos offset) {
        return StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)this.portalOffset).m_141952_((Vec3i)offset);
    }

    public BlockPos getInitialSpawnOffsetForControllerPos(StructurePlaceSettings settings, BlockPos controllerPos) {
        if (this.controllerOffset == null) {
            return controllerPos;
        }
        return controllerPos.m_141950_((Vec3i)StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)this.controllerOffset));
    }

    public List<BlockPos> getDoorOffsetsForFacing(StructurePlaceSettings settings, String doorType, Direction facing, BlockPos offset) {
        Direction originalFacing;
        Map<Direction, List<BlockPos>> doorDirMap;
        ArrayList<BlockPos> offsetList = new ArrayList<BlockPos>();
        if (this.doorMap.containsKey(doorType) && (doorDirMap = this.doorMap.get(doorType)).containsKey(originalFacing = DungeonUtil.reverseRotate(settings.m_74401_(), settings.m_74404_(), facing))) {
            List<BlockPos> doorList = doorDirMap.get(originalFacing);
            for (BlockPos doorPos : doorList) {
                offsetList.add(StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)doorPos).m_141952_((Vec3i)offset));
            }
        }
        return offsetList;
    }

    public Map<String, List<BlockPos>> getAllDoorOffsetsForFacing(StructurePlaceSettings settings, Direction facing, BlockPos offset) {
        TreeMap<String, List<BlockPos>> offsetMap = new TreeMap<String, List<BlockPos>>();
        for (String type : this.doorMap.keySet()) {
            offsetMap.put(type, this.getDoorOffsetsForFacing(settings, type, facing, offset));
        }
        return offsetMap;
    }

    public boolean placeStructureAtPosition(Random rand, StructurePlaceSettings settings, ServerLevel world, BlockPos pos) {
        TreeMap compositeMap = new TreeMap();
        for (Map.Entry<String, BlockPos> entry : this.structureMap.entrySet()) {
            BlockPos key = entry.getValue();
            String structure = entry.getKey();
            if (compositeMap.containsKey(key)) {
                ((List)compositeMap.get(key)).add(structure);
                continue;
            }
            compositeMap.put(key, new ArrayList());
            ((List)compositeMap.get(key)).add(structure);
        }
        for (Map.Entry<String, Object> entry : compositeMap.entrySet()) {
            ResourceLocation location = new ResourceLocation((String)((List)entry.getValue()).get(rand.nextInt(((List)entry.getValue()).size())));
            BlockPos offsetPos = StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)((BlockPos)entry.getKey()));
            DungeonStructure structure = new DungeonStructure(location);
            structure.placeStructureAtPosition(rand, settings, world, pos.m_141952_((Vec3i)offsetPos));
        }
        return true;
    }
}

